function [pos,opos,tinset] = ax_pos(axh,units)
%a little function that return the position and outside position of the 
%axis specified by the handle and in units specified by the user.
%syntax: [pos,opos,tinset] = ax_pos(axh,units);
%input: axh = the handle of the axis, could be singleton or a vertical
%           vector.
%       units = the units returned by the function.  Can be: inches,
%           centimeters, normalized, points, pixels, characters.
%output: pos = the position of the axis
%        opos = the outerposition of the axis
%        tinset = the tightinset of the axis

for i = 1:size(axh,1)   %step through the handles
    orig_units = get(axh(i,1),'Units');     %get the original unit type of the axis
    if ~strcmp(orig_units,units)            %if the user defined unit and the current unit are not the same
        set(axh(i,1),'Units',units)         %set to user defined unit
    end
    %get position
    pos(i,:) = get(axh(i,1),'Position');
    opos(i,:) = get(axh(i,1),'OuterPosition');
    tinset(i,:) = get(axh(i,1),'TightInset');
    %return to original unit type
    if ~strcmp(orig_units,units);
        set(axh(i,1),'Units',orig_units)
    end
end